<?php

namespace App\Database\Migrations;

use CodeIgniter\Database\Migration;

class AddBrandingSchoolInfo extends Migration
{
    public function up()
{
    $db = \Config\Database::connect();
    $fields = $db->getFieldNames('school_info'); // ambil semua kolom yang ada

    $add = [];

    if (!in_array('school_name', $fields)) {
        $add['school_name'] = ['type' => 'VARCHAR', 'constraint' => 150, 'null' => true];
    }
    if (!in_array('logo_path', $fields)) {
        $add['logo_path'] = ['type' => 'VARCHAR', 'constraint' => 255, 'null' => true];
    }
    if (!in_array('hero_bg_path', $fields)) {
        $add['hero_bg_path'] = ['type' => 'VARCHAR', 'constraint' => 255, 'null' => true];
    }

    if (!empty($add)) {
        $this->forge->addColumn('school_info', $add);
    }
}



    public function down()
    {
        $this->forge->dropColumn('school_info', ['school_name', 'logo_path', 'hero_bg_path']);
    }
}
